/*:ja
 * @plugindesc アクターから範囲内にあるイベントのセルフスイッチCをONにします
 * @author TRS
 *
 * @param メモ内容
 * @desc このメモがついてるイベントを対象にします
 * @default sasoi
 *
 * @param 範囲設定
 * @desc 範囲を指定します(1～8)
 * @type number
 * @min 1
 * @max 8
 * @default 3
 *
 * @param バルーン番号
 * @decs 誘えた時に出すバルーンの番号
 * @type number
 * @min 1
 * @max 15
 * @default 4
 *
 * @help プラグインコマンド
 * <誘う開始> 
 * ・プレイヤーから範囲内に、イベントのメモ欄にパラメーターで設定した
 * 'メモ内容'のあるものを対象に、セルフスイッチCをONにします
 * 
 * 
*/
(function()
{
	var parameters = PluginManager.parameters('Sasou');
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	
	var strMemo = parameters['メモ内容'];
	var intLimit = Number(parameters['範囲設定'] || 0);
	var intBaloonNo = Number( parameters['バルーン番号'] || 4);
	
	Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if(command === "誘う開始")
		{
			var PlayerXpos = this.character(-1)._x;				//プレイヤーX座標
			var PlayerYpos = this.character(-1)._y;				//プレイヤーY座標
			
			var i,j;
			var SwitchOkEventId = 0;
			
			for( j = 0; j < intLimit; j++)
			{
				for( i = 0; i < intLimit; i++)
				{
					SetSelfSwitch(PlayerXpos - i, PlayerYpos - j );
					SetSelfSwitch(PlayerXpos + i, PlayerYpos - j );
					SetSelfSwitch(PlayerXpos - i, PlayerYpos + j );
					SetSelfSwitch(PlayerXpos + i, PlayerYpos + j );
					
				}
			}
		}
	}
	
	/**
	 * メモのあるイベントのセルフスイッチON
	 */
	function SetSelfSwitch( x, y)
	{
		var EventId = $gameMap.eventIdXy(x,y);
		//0じゃない
		if(EventId != 0)
		{
			//メモあるか
			if($dataMap.events[EventId].meta[strMemo])
			{
				var key = [$gameMap.mapId(), EventId, 'C'];
				$gameSelfSwitches.setValue(key, true);					//対象イベントセルフスイッチON
				$gameMap.events()[EventId - 1].requestBalloon(intBaloonNo);
			}
		}
	}
	
	//-----------------------------------------------------------------------------
	// 場所移動オーバーライド
	//
	// The scene class of the map screen.
	Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
	    this._transferring = true;
	    this._newMapId = mapId;
	    this._newX = x;
	    this._newY = y;
	    this._newDirection = d;
	    this._fadeType = fadeType;
	    
	    //マップ上にあるデータから、指定されたメモ内容を判断し、対象のセルフスイッチをOFFにします
		for(var i = 1; i <= $gameMap.events().length ; i++)
		{
			var chkWrk_ID = $gameMap.events()[i - 1].eventId();
			
			//ロード時にイベントにアクセスできないときは飛ばす
			try
			{
				if( $dataMap.events[chkWrk_ID].meta[strMemo] )
				{
					key = [$gameMap._mapId, i, "C"];
					$gameSelfSwitches.setValue(key, false);
					
				}
			}
			catch (e)
			{
				continue;
			}
		}
	}
}());
